/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import slimeknights.mantle.data.NamedComponentRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.MeleeHarvestToolStatsBuilder;
import slimeknights.tconstruct.tools.RangedToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public class ToolStatProviders {
    public static final NamedComponentRegistry<IToolStatProvider> REGISTRY = new NamedComponentRegistry("Tool Stat Provider");
    public static final IToolStatProvider NO_PARTS = ToolStatProviders.register("no_parts", new IToolStatProvider(){

        @Override
        public StatsNBT buildStats(ToolDefinition definition, MaterialNBT materials) {
            return ToolStatsBuilder.noParts(definition).buildStats();
        }

        @Override
        public boolean isMultipart() {
            return false;
        }

        @Override
        public void validate(ToolDefinitionData data) {
            if (!data.getParts().isEmpty()) {
                throw new IllegalStateException("Cannot have parts for a specialized tool");
            }
        }
    });
    public static final IToolStatProvider MELEE_HARVEST = ToolStatProviders.register("melee_harvest", new IToolStatProvider(){
        private static final Set<MaterialStatsId> VALID_STATS = ImmutableSet.of((Object)((Object)HandleMaterialStats.ID), (Object)((Object)ExtraMaterialStats.ID));

        @Override
        public StatsNBT buildStats(ToolDefinition definition, MaterialNBT materials) {
            return MeleeHarvestToolStatsBuilder.from(definition, materials).buildStats();
        }

        @Override
        public boolean isMultipart() {
            return true;
        }

        @Override
        public void validate(ToolDefinitionData data) {
            IToolStatProvider.validate("Melee/Harvest", HeadMaterialStats.ID, VALID_STATS, data);
        }
    });
    public static final IToolStatProvider RANGED = ToolStatProviders.register("ranged", new IToolStatProvider(){
        private static final Set<MaterialStatsId> VALID_STATS = ImmutableSet.of((Object)((Object)BowstringMaterialStats.ID), (Object)((Object)GripMaterialStats.ID));

        @Override
        public StatsNBT buildStats(ToolDefinition definition, MaterialNBT materials) {
            return RangedToolStatsBuilder.from(definition, materials).buildStats();
        }

        @Override
        public boolean isMultipart() {
            return true;
        }

        @Override
        public void validate(ToolDefinitionData data) {
            IToolStatProvider.validate("Ranged", LimbMaterialStats.ID, VALID_STATS, data);
        }
    });

    private static IToolStatProvider register(String name, IToolStatProvider instance) {
        return (IToolStatProvider)REGISTRY.register(TConstruct.getResource(name), (Object)instance);
    }
}

